<?php

/** Implements the rebuildtreeview, parsetreeview, treeviewcachestatus actions
  * as reached through the (pseudo-) configuration page's corresponding tabs:
  * 'Parse configuration', 'Rebuild treeview', 'Cache status'
  */
abstract class TreeviewAction extends FormlessAction {
	public function onView() {
		return null;
	}

	public function show() {
		global $wgHierarchyPage;

		$out = $this->getOutput();
		$article = $this->getArticle();

		$action = $this->getName();
		$title = $this->getTitle();

		if ($action == 'view_tv') {
			global $wgUseFileCache;
			wfDebug('TreeviewAction::show(): setting '.
			"$wgUseFileCache false.\n");
			$wgUseFileCache = false;
			$article->view();
			$handled = true;
		} else if ($action == 'rebuildtreeview' || $action == 'parsetreeview' ||
		$action == 'treeviewcachestatus') {
			$handled = true;
			if (!RequestContext::getMain()->getUser()->isAllowed($action)) {
				$handled = false;
				$out->permissionRequired($action);
			} else {
				$res = Hierarchy::isConfigPage($title);
				if ($res === false) {
					$sk = RequestContext::getMain()->getSkin();
					/* This repeats the title creation within
					* isConfigPage() but it is rarely reached and
					* is not time-critical.
					*/
					$tConfig = Hierarchy::getConfigPageTitle(true);
					$configHref = $tConfig
					  ? MediaWikiServices::getInstance()->getLinkRenderer()->makeLink($tConfig)
					  : wfMessage('tv_invalid')->plain().wfMessage(
					     'tv_invconfpg', $wgHierarchyPage)->plain();
					$out->addHTML(wfMessage(
					  'tv_err_actionforconf', $action,
					  $configHref)->text());
				} else {
					$s = '<h1>'.wfMessage('tv_'.$action)->escaped().
					"</h1>\n";
					$hObj = new Hierarchy;
					if ($action == 'rebuildtreeview' ||
					$action == 'treeviewcachestatus') {
						/* This is called prior to the call to
						* parseConfigPage() so that a re-parse
						* is avoided. */
						$cacheHit = $hObj->loadHierarchy();
						$ts = $hObj->getHierarchyTs();
					}
					if ($action != 'treeviewcachestatus') {
						$parseRes = $hObj->parseConfigPage();
					}
					if ($res === 0) {
						$s .= '<h2>'.
						wfMessage('tv_standin_hdr')
						->escaped()."</h2>\n".
						wfMessage('tv_standinconfpg_desc')
						->escaped()."\n";
					}
					if ($action == 'rebuildtreeview') {
						/* The parse result is stored in the
						* object so that this call does not
						* invoke a re-parse. */
						$hObj->buildHierarchyAndRemappings();
						$hObj->saveRemappings();
						$hObj->saveHierarchy();
						$cacheHit2 = $hObj->loadHierarchy();
						$ts2 = $hObj->getHierarchyTs();
						$k = $cacheHit2 ?
						'tv_rebuildsucc' : 'tv_rebuildmiss';
						$postStat = '<h2>'.wfMessage($k.'_hdr')
						->escaped()."</h2>\n".wfMessage($k)
						->escaped().'<h2>'.wfMessage(
						'tv_cachestatpost_hdr')->escaped().
						"</h2>\n".wfMessage($cacheHit2 === 0 ?
						'tv_unusablecachehit' : ($cacheHit2 ?
						'tv_cachehit':'tv_cachemiss'),$ts2)
						->escaped()."\n";
					} else {
						$cacheHit2 = false;
						$postStat = '';
					}
					/* Output the result of the cache retrieval(s).
					* Warn if the cache seems non-functional. */
					if ($action == 'rebuildtreeview' ||
					$action == 'treeviewcachestatus') {
						global $wgMainCacheType;
						if ($cacheHit2 === false &&
						$cacheHit === false &&
						$wgMainCacheType == CACHE_NONE) {
							$s .= '<h2>'.wfMessage(
							'tv_nocache_hdr')->escaped().
							"</h2>\n".wfMessage(
							'tv_nocache')->escaped();
						}
						$s .= $postStat;
						$hdrKey = $action == 'rebuildtreeview' ?
						'tv_cachestatpre_hdr' :
						'tv_cachestatus_hdr';
						$s .= '<h2>'.wfMessage($hdrKey)
						->escaped().
						"</h2>\n".wfMessage($cacheHit === 0 ?
						'tv_unusablecachehit' : ($cacheHit ?
						'tv_cachehit':'tv_cachemiss'),$ts)
						->escaped()."\n";
					}
					/* Output parse diagnostics. */
					if ($action != 'treeviewcachestatus') {
						$s .= '<h2>'.wfMessage(
						'tv_parseerrintro')->escaped().
						"</h2>\n".($parseRes ?
						wfMessage('tv_noproblems')
						->escaped() :
						$hObj->getParseErrors_Html());
					}
					$s .= '<h1>'.wfMessage('tv_content')->escaped()
					."</h1>\n";
					$out->addHTML("$s\n");
					$out->addWikiTextAsInterface($hObj->getConfigPageText());
				}
			}
		} else	$handled = false;
		/* For MediaWiki 1.6.5, a return value of false is interpreted as
		* 'unhandled'; for MediaWiki 1.5.6, 1.7.1 and 1.12.0, a return value of
		* true is interpreted in that way.  We cater to the later versions
		* here.
		*/
		return !$handled;
	}
}

class ParsetreeviewAction extends TreeviewAction {
	public function getName() {
		return 'parsetreeview';
	}
}

class RebuildtreeviewAction extends TreeviewAction {
	public function getName() {
		return 'rebuildtreeview';
	}
}

class TreeviewcachestatusAction extends TreeviewAction {
	public function getName() {
		return 'treeviewcachestatus';
	}
}

class View_tvAction extends TreeviewAction {
	public function getName() {
		return 'view_tv';
	}
}
