<?php

/**
 * Treeview skin for MediaWiki
 *
 * Supports a configurable and automatically generated treeview component that
 * displays the wiki's contents and/or external links, as well as other
 * features.  See README.Treeview for a fuller description and for installation
 * instructions.
 *
 * Licenced under the General Public Licence 2, without warranty.
 *
 * @licence GPL2 http://www.gnu.org/copyleft/gpl.html
 * @author Laird Shaw <lairdshaw77@gmail.com>
 * @package MediaWiki
 * @subpackage Skins
 */

use MediaWiki\Linker\Linker;
use MediaWiki\Title\Title;
use MediaWiki\Html\Html;

global $IP;
/** because this code extends the SkinTemplate class */
require_once("$IP/includes/skins/SkinTemplate.php");
require_once "$IP/extensions/Hierarchy/Hierarchy.php";

$wgValidSkinNames['treeview'] = 'Treeview';
$GLOBALS['wgMessagesDirs']['Treeview'] = __DIR__.'/i18n';

if (!defined('MEDIAWIKI')) die();
if (!class_exists('Hierarchy')) {
	die('The Hierarchy class is not available to the Treeview skin. '.
	  'Consult the installation notes - the most likely solution though '.
	  'is to add the following line to LocalSettings.php:'.
	  "<pre>include(\"\$IP/extensions/Hierarchy/SpecialHierarchy.php\");".
	  "</pre>");
}

/**
 * Inherit main code from SkinTemplate, set the CSS and template filter.
 * @todo document
 * @package MediaWiki
 * @subpackage Skins
 */
class SkinTreeview extends SkinTemplate {
	var $mRemappings;
	var $mDisableDefaultRedirectSubHeadings;
	var $skinname = 'treeview', $stylename = 'Treeview',
		$template = 'TreeviewTemplate', $useHeadElement = true;

	function __construct() {
		parent::__construct([
			'name' => 'treeview',
			'templateDirectory' => __DIR__,
		]);
		$this->mDisableDefaultRedirectSubHeadings = true;
	}

	function selfIdentify() {
		$this->skinname  = 'treeview';
		$this->stylename = 'Treeview';
		$this->template  = 'TreeviewTemplate';
	}

	function getDefaultModules() {
		$modules = parent::getDefaultModules();
	
		$modules['styles']['core'] = $this->getSkinStyles();

		return $modules;
	}

	protected function getSkinStyles() {
		$styles = ['skins.treeview.styles'];

		return $styles;
	}

	/** Using Treeview. */
	function initPage(OutputPage $out) {
		SkinTemplate::initPage($out);
		$this->selfIdentify();
	}

	/** Main entry point; effectively extends SkinTemplate::outputPage() */
	function outputPage_ex(&$tpl) {
		global $wgArticle, $wgTitle, $wgShowPoweredByIcon,
		  $wgOut, $wgShowCopyrightIcon, $wgScriptPath, $wgScript,
		  $wgUsePathInfo, $wgRequest, $wgCookiePath, $wgHierarchy,
		  $wgAllowRelNext, $wgTreeviewIconHeight, $wgTreeviewIconWidth,
		  $wgTV_RedirectedFrom;

		$fname = 'SkinTreeview::outputPage_ex';

		$aliases = '';

		# in lieu of DefaultSettings.php entries
		if (!isset($wgShowPoweredByIcon)) $wgShowPoweredByIcon = true;
		if (!isset($wgShowCopyrightIcon)) $wgShowCopyrightIcon = true;
		if (!isset($wgAllowRelNext)) $wgAllowRelNext = true;
		if (!isset($wgSkinTreeviewCookieRoot)) {
			$wgSkinTreeviewCookieRoot = '/';
		}
		if (!isset($wgTreeviewHelpPage)) {
			$wgTreeviewHelpPage = 'Help:Treeview skin:Treeview';
		}

		# This was a text string in 1.5.8 but by 1.6.5 it's become a
		# title object
		if (isset($wgTV_RedirectedFrom)) {
			$tRedirectedFrom = $wgTV_RedirectedFrom;
		} else if (isset($wgArticle->mRedirectedFrom)) {
			if (is_object($wgArticle->mRedirectedFrom)) {
				$tRedirectedFrom = $wgArticle->mRedirectedFrom;
			} else	$tRedirectedFrom = Title::newFromText(
			  $wgArticle->mRedirectedFrom);
		} else	$tRedirectedFrom = false;

		$state = new TVstate(array(
		  'tEffective'   => ($wgArticle ? $wgArticle->getTitle() : $wgTitle),
		  'redirectInfo' => $tRedirectedFrom ? $tRedirectedFrom : false
		));
		if (!isset($wgHierarchy)) $wgHierarchy = new Hierarchy($state);
		$this->mRemappings = $wgHierarchy->getRemappings();

		$tEffective = $tRedirectedFrom ? $tRedirectedFrom : ($this->getTitle() ? $this->getTitle() : ($wgArticle ? $wgArticle->getTitle() : $wgTitle));
		$wgOut->setPageTitle($this->remapFullTitle(
		  $tEffective->getPrefixedText()));
		$tpl->set('pagetitle', $wgOut->getHTMLTitle());

		$hlinks = $wgHierarchy->buildHierarchyHtml();
		if (!$hlinks) {
			$tHierarchy = Title::makeTitle(NS_SPECIAL, 'Hierarchy');
			$tpl->set('hempty', Html::element('a',
			  array('href' => $tHierarchy->getLocalURL()),
			  wfMessage('tv_diagnoseempty')->escaped()));
		} else	$tpl->set('hempty', '');
		$newState = $wgHierarchy->getState();
		$newStateStr = $newState->getStateStr();
		$tpl->set('tvstate', $newStateStr);

		$h = $wgHierarchy->getCurrentHierarchy();
		$navbar = $this->buildNavBar($tEffective, $h, $newStateStr);

		$primary = ' <span class="subscript" title="'.
		  wfMessage('tv_tt_primaryalias')->escaped().'">'.
		  '['.wfMessage('tv_primary')->escaped().']</span>';
		$titleHtml = $this->getContextualisedTitle(
		  $tEffective->getPrefixedText(), $h);
		if ($tRedirectedFrom) {
			$title = isset($wgArticle)
			           ? $wgArticle->getTitle()
			           : $this->getContext()->getTitle();
			$tpl->set('alias', '['.Html::element('a',
			  array('href' => $tRedirectedFrom->
			    getLocalURL('redirect=no')),
			  wfMessage('tv_aliased')->escaped()).']');
			$aliases .= '<span class="alias">'.
			  $this->getContextualisedTitle($title->
			    getPrefixedText(), $h, true/*linkLast*/).
			  $primary.'</span>';
		} else	$tpl->set('alias', '');
		# defined in Hierarchy/UtilityFunctions.php.
		$redirs = wfGetRedirectsTo(($wgArticle ? $wgArticle->getTitle() : $this->getContext()->getTitle()/*$wgTitle*/));
		if (count($redirs) > 0) {
			if (!$tRedirectedFrom) {
				$titleHtml .= $primary;
			}
			foreach ($redirs as $ttl) {
				if (!($tRedirectedFrom &&
				  $tRedirectedFrom->getPrefixedText() ==
				  $ttl->getPrefixedText())) {
					if ($aliases) $aliases .= ' | ';
					$aliases .= '<span class="alias">'.
					  $this->getContextualisedTitle(
					    $ttl->getPrefixedText(), $h,
					    true/*linkLast*/,
					    true/*singleLink*/).'</span>';
				}
			}
		}
		if (!empty($aliases)) $aliases =
		  '<span class="aliasestxt">'.wfMessage('tv_aliases')
		  ->escaped().':</span> '.$aliases;
		if ($related = $this->getSeeAlsos(($wgArticle ?
		  $wgArticle->getTitle() : $wgTitle), $h)) {
			$related = '<span class="relatedtxt">'.
			  wfMessage('tv_closely_related')->escaped().
			  ':</span> '.$related;
		}

		$tpl->set('title', $titleHtml);
		$tpl->set('aliases', $aliases);
		$tpl->set('related', $related);
		$tpl->set('hlinks', $hlinks);
		$tpl->set('navbar', $navbar);
		$tpl->set('cookieroot', $wgCookiePath);
		$tpl->set('script', $wgScript);
		$tpl->set('pagedbtitle', urlencode($tEffective->
		  getPrefixedDBkey()));
		$tpl->set('jsmimetype', 'text/javascript');
		# There's a msgWiki() function in SkinTemplate but it results
		# in enclosing <p></p> tags; this method avoids that.
		$tpl->set('sitecopyright',
		  $wgOut->parseAsContent(wfMessage('site_copyright')->escaped(), false));
		$spechier = Title::newFromText('Hierarchy', NS_SPECIAL);

		if (isset($_SERVER['PATH_INFO']) && $wgUsePathInfo) {
			$pos  = strpos($_SERVER['REQUEST_URI'],
			               $_SERVER['PATH_INFO'  ]);
			# probably PATH_INFO has been unencoded; the code could
			# retry a strpos against a re-encoded PATH_INFO but
			# it's likely that some thus-encoded characters would
			# not have been encoded in the first place
			if ($pos === false) {
				$effttl = urlencode(
				  substr($_SERVER['PATH_INFO'], 1));
				$base = 'effttl='.$effttl.'&';
			} else {
				$base = substr($_SERVER['REQUEST_URI'],0,$pos);
				$base = 'base='.urlencode($base).'&';
			}
		} else {
			$base = 'effttl='.urlencode($tEffective->getPrefixedText()).'&';
		}
		$tpl->set('xmlurl', $spechier->getLocalURL($base.
		  'effurl='.urlencode($wgRequest->getRequestURL()).
		  '&expnodeids='));
		$tpl->set('expandednodes',$wgHierarchy->getExpandedNodesStr());
		if (!$wgShowPoweredByIcon) {
			# could be done with display: hide in the CSS but this
			# avoids having a browser even process (or potentially
			# download) the image
			$tpl->set('poweredbyico', '');
		}
		if (!$wgShowCopyrightIcon) {
			$tpl->set('copyrightico', '');
		}
		if ($t = Title::makeTitle(NS_SPECIAL, 'Userlogin')) {
			$login_url = htmlspecialchars($t->getLocalURL());
		}
		$tpl->set('ledmsg', wfMessage(RequestContext::getMain()->getUser()->isRegistered() ?
		  'tv_tt_logged_in' : 'tv_tt_not_logged_in')->escaped());
		$tpl->set('ledurl', RequestContext::getMain()->getUser()->isRegistered() ?
		  'javascript:dropdown(\'p-personal\')' : $login_url);
		$tpl->set('ledimgname', (RequestContext::getMain()->getUser()->isRegistered() ?
		  'green' : 'grey').'led.png');
		$tpl->set('isloggedin', RequestContext::getMain()->getUser()->isRegistered() ? '1' : '0');
		$t = Title::newFromText($wgTreeviewHelpPage);
		$tpl->set('tvhelpurl', $t ? htmlspecialchars($t->getLocalURL(
		  $newStateStr ? "tvstate=$newStateStr" : '')) : '');
		$tpl->set('tvhelpbaseurl', $t ? htmlspecialchars($t->
		  getLocalURL()) : '');
		$tpl->set('tvhelppage',$t?urlencode($t->getPrefixedDBkey()):'');
	}

	function getDefaultTVicons() {
		global $wgStylePath;
		foreach (array('leaf', 'plus', 'minus') as $i => $name) {
			$deficons[$i] = "$wgStylePath/{$this->stylename}/".
			  "$name.png";
		}
		return $deficons;
	}

	function remapFullTitle($titleText) {
		$ctxarr = explode(':', $titleText);
		if (isset($this->mRemappings[$titleText])) {
			$ctxarr[count($ctxarr) - 1] =
			  $this->mRemappings[$titleText];
		}
		return implode(':', $ctxarr);
	}

	/** copied from Skin::subPageSubtitle() and modified */
	function getContextualisedTitle($titleText, $hierarchy = array(),
	  $linkLast = false, $singleLink = false) {
		$linker = /* class_exists('DummyLinker') ? new DummyLinker() : */new Linker();

		$contexts = explode(':', $titleText);
		$h = $hierarchy;
		$ret = '';
		$growingTitle = '';
		if ($singleLink) $fullDisp = '';
		for ($i = 0; $i < count($contexts); $i++) {
			$subC = $contexts[$i];
			$growingTitle .= $subC;
			$displayName = isset($this->mRemappings[$growingTitle]) ?
			  $this->mRemappings[$growingTitle] : $subC;
			if ($singleLink) {
				if ($fullDisp) $fullDisp .= ':';
				$fullDisp .= $displayName;
			}
			if ($ret) $ret .= ':';
			if ($i == count($contexts) - 1 || !$singleLink) {
				if ($i < count($contexts) - 1 || $linkLast) {
					$t = Title::newFromText($growingTitle);
					$link = $linker->link($t,
					  htmlspecialchars($singleLink ?
					  $fullDisp : $displayName));
					$ret .= $link;
				} else {
					$ret .= '<span class="lastpartialcxt">'.
					  ($singleLink?$fullDisp:$displayName).
					  '</span>';
				}
			}
			$growingTitle .= ':';
			if (isset($h[0][$subC])) {
				$h = $h[0][$subC];
			}
		}
		return $ret;
	}

	function getSeeAlsos($nt, $h = array()) {
		global $wgOut;
		$fname = 'SkinTreeview::getSeeAlsos';

		$related = '';

		# wfGetSeeAlsos() is defined in Hierarchy/UtilityFunctions.php
		foreach (wfGetSeeAlsos($nt) as $t) {
			if ($related) $related .= ' | ';
			$related .= '<span class="related">'.$this->
			  getContextualisedTitle($t->getPrefixedText(), $h,
			    true/*linkLast*/, true/*singleLink*/).'</span>';
		}
		return $related;
	}

	function buildNavBar($title, $h, $statestr) {
		$fname = 'SkinTreeview::buildNavBar';

		$html = $data = $extra = '';

		global $wgRequest, $wgStylePath, $action, $wgAllowRelNext;
		$qrynodeid = $wgRequest->getVal('nodeid');
		# we locate the first node that matches; if multiple matches
		# exist in the hierarchy they need to be differentiated in the
		# config page by nodeids and use the appendnodeid option -
		# this won't be effective though unless the page is arrived at
		# by a treeview click or &nodeid=<id> is manually appended to
		# the url's query
		$navarr = $this->getNavArr($title->getPrefixedText(),
		  $qrynodeid, $h);
		# don't pass through the edit invoked by default when this
		# article is reached by following a non-existing-so-create-by-
		# edit link
		if ($action && $action != 'view' &&
		  !($action == 'edit' && !$title->exists())) {
			$extra = "action=$action";
		}
		if ($statestr) {
			if ($extra) $extra .= '&';
			$extra .= 'tvstate='.$statestr;
		}
		$navconf = array(
			'first'		=> array(
				'alt' => '|&lt;',
				'rel' => 'start'
			),
			'prev'		=> array(
				'alt' => '&lt;',
				'altskip' => '&lt;..',
				'rel' => 'prev',
			),
			'prevchild'	=> array(
				'alt' => '&lt;/'
			),
			'prevparent'	=> array(
				'alt' => '&lt;\\',
			),
			'parent'	=> array(
				'alt' => '^',
// there is no such rel type, 'up', nor any suitable alternative
//				'rel' => 'up',
			),
			'nextparent'	=> array(
				'alt' => '/>',
			),
			'firstchild'	=> array(
				'alt' => '\>',
// there is no such rel type, 'child', nor any suitable alternative
//				'rel' => 'child',
			),
			'next'		=> array(
				'alt' => '>',
				'altskip' => '..>',
				/* dependent on $wgAllowRelNext below since
				 * some wikis may want to avoid the precaching
				 * hits from browsers that this may imply
				 */
//				'rel' => 'next',
			),
			'last'		=> array(
				'alt' => '>|',
// there is no such rel type, 'end', nor any suitable alternative
//				'rel' => 'end',
			),
		);
		if ($wgAllowRelNext) $navconf['next']['rel'] = 'next';
		foreach ($navconf as $k => $conf) {
			if (isset($navarr[$k]['title'])) {
				$ttl = Title::newFromText($navarr[$k]['title']);
			} else $ttl = null;
			$imgname = $k;
			if (isset($navarr["{$k}skip"])) {
				$imgname .=  'skip';
				$alt = $conf['altskip'];
				$rel = $rev = '';
			} else {
				$alt = $conf['alt'];
				$rel = isset($conf['rel']) ? $conf['rel'] : '';
			}
			$html .= ($ttl ? '<a href="'.htmlspecialchars($ttl->
			  getLocalURL($extra)).'" '.'title="'.htmlspecialchars(
			  $ttl->getPrefixedText()).'"'.
			  ($rel ? " rel=\"$rel\"" : '') :
			  ('<span'.(isset($navarr[$k]['dispname']) ?
			     ' title="'.$navarr[$k]['dispname'].'"' : ''))).
			   ' id="nav'.$k.'">';
			$html .= "<img src=\"$wgStylePath/{$this->stylename}/".
			  $imgname.($ttl ? '' : '_inactive').'.png" '.
			  "alt=\"$alt\" />".($ttl ? '</a>' : '</span>')."\n";
			if ($ttl) {
			  $data .= '<input type="hidden" id="baseurl.'.
			    "nav$k\" value=\"".htmlspecialchars($ttl->
			    getLocalURL()).
			    "\" />\n".
			    "<input type=\"hidden\" id=\"dbttl.nav$k\" ".
			    "value=\"".htmlspecialchars($ttl->
			      getPrefixedDBkey()).'" />'."\n";
			}
		}
		$html .= $data;
		return $html;
	}

	/**
	 * Searches the tree $h for the node matching the title $titleText and
	 * node id $qrynodeid; if found, returns an associative array of nodes
	 * with keys: 'first' (sibling), 'prev' (sibling or, if the 'prevskip'
	 * key is set true, of the first encountered prior node at the same
	 * depth), prevchild', 'prevparent', 'parent', 'nextparent',
	 * 'firstchild', 'next' (sibling or, if the 'nextskip' key is true, of
	 * the first encountered subsequent node at the same depth), 'last'
	 * (sibling).  Any members without an appropriate node are unset or set
	 * to null.  If no matching node is found, null/unset is returned rather
	 * than an array.
	 * @todo Move this and the three related methods into the Hierarchy
	 * object where they more properly belong.
	 */
	function getNavArr($titleText, $qrynodeid, $h) {
		$ret = $this->findNodeNav_r($titleText, $qrynodeid, $h, $null1,
		  $null2);
		if ($ret) {
			# handle the corner-case of a hierarchy consisting of a single
			# node and that node matching the search criteria
			if ($ret['nextparent'] == -1) $ret['nextparent'] = null;
			if ($ret['prevparent'] == -1) $ret['prevparent'] = null;
		}
		return $ret;
	}

	function findNodeNav_r($titleText, $qrynodeid, $h, &$prev_depth,
	  &$next_depth) {
		$ret = null;
		$lastidx = count($h['nodes']) - 1;
		for ($i = 0; $i <= $lastidx; $i++) {
			$node = $h['nodes'][$i];
			if ($titleText == $node['title'] &&
			    !isset($node['urlextra']) &&
			    !isset($node['nomatch']) &&
			    ($qrynodeid == $node['id'] || $qrynodeid == '')) {
				$ret = array(
				  'prevparent' => -1,
				  'parent'     => !isset($h['ROOT']) ? null : $h,
				  'nextparent' => -1,
				  'firstchild'  => $lastidx >= 0 &&
				                   isset($node['nodes'][0])
				                     ? $node['nodes'][0] : null,
				);
				if ($i > 0) {
					$prev_depth = 0;
					$ret['prev' ] = $h['nodes'][$i - 1];
					$ret['first'] = $h['nodes'][0];
					$ret['prevchild'] = $this->prevAtDepth(
					  $h['nodes'][$i - 1], 1);
				} else	{
					$prev_depth = 1;
					$ret['prevskip'] = true;
				}
				if ($i < $lastidx) {
					$next_depth = 0;
					$ret['next'] = $h['nodes'][$i + 1];
					$ret['last'] = $h['nodes'][$lastidx];
				} else {
					$next_depth = 1;
					$ret['nextskip'] = true;
				}
				break;
			} else {
				$ret = $this->findNodeNav_r($titleText,
				  $qrynodeid, $node, $prev_depth, $next_depth);
				if (is_array($ret)) {
					if ($ret['nextparent'] == -1) {
						$ret['nextparent'] =
						  $i < $lastidx ?
						  $h['nodes'][$i + 1] : null;
					}
					if ($ret['prevparent'] == -1) {
						$ret['prevparent'] = $i > 0 ?
						  $h['nodes'][$i - 1] : null;
					}
					if ($prev_depth > 0) {
						if ($i > 0) {
							$ret['prev'] = $this->
							  prevAtDepth($h,
							  $prev_depth+1, $i-1);
						}
						if (!empty($ret['prev'])) $prev_depth=0;
						else $prev_depth++;
					}
					if ($next_depth > 0) {
						if ($i < $lastidx) {
							$ret['next'] = $this->
							  nextAtDepth($h,
							  $next_depth+1, $i+1);
						}
						if (!empty($ret['next'])) $next_depth=0;
						else $next_depth++;
					}
					break;
				}
			}
		}
		return $ret;
	}

	function prevAtDepth($h, $depth, $start = -1) {
		$cnt = count($h['nodes']);
		if ($cnt <= 0 || $depth <= 0) return null;
		else if ($depth == 1) return $h['nodes'][$cnt - 1];
		else {
			if ($start < 0) $start = $cnt - 1;
			for ($i = $start; $i >= 0; $i--) {
				$ret = $this->prevAtDepth($h['nodes'][$i],
				  $depth - 1);
				if ($ret) break;
			}
			return $ret;
		}
	}

	function nextAtDepth($h, $depth, $start = 0) {
		$cnt = count($h['nodes']);
		if ($cnt <= 0 || $depth <= 0) return null;
		else if ($depth == 1) return $h['nodes'][0];
		else {
			for ($i = $start; $i < $cnt; $i++) {
				$ret = $this->nextAtDepth($h['nodes'][$i],
				  $depth - 1);
				if ($ret) break;
			}
			return $ret;
		}
	}
}

/**
 * @todo document
 * @package MediaWiki
 * @subpackage Skins
 */
class TreeviewTemplate extends BaseTemplate {
	var $skin;

	/**
	 * Template filter callback for Treeview skin.
	 * Takes an associative array of data set from a SkinTemplate-based
	 * class, and a wrapper for MediaWiki's localization database, and
	 * outputs a formatted page.
	 *
	 * @access private
	 */
	function execute() {
		global $wgRequest, $wgScriptPath, $wgTreeviewDisableViewcount;

		# Required because the template is created, populated and then
		# this execute() method is called all within one function -
		# SkinTemplate::outputPage() - and there's no other way for a
		# descendant class to hook in
		$sk = $this->getSkin();
		$sk->outputPage_ex($this);

		$this->skin = $skin = $this->data['skin'];
		$action = $wgRequest->getText( 'action' );

		$out = $sk->getOutput();
?><div id="globalWrapper">
      <div id="column-content">
	<div id="content-borderbox1">
	<div id="content-borderbox2">
	<div id="content">
	  <a id="top"></a><!-- IE glitch without this -->
	  <div id="header">
	    <?php if($this->data['sitenotice']) { ?><div id="siteNotice"><?php $this->html('sitenotice') ?></div><?php } ?>
	    <!-- BEGIN data communicated to the client-side treeview code -->
	    <form action="#"><!-- dummy to prevent (lynx's) validation errors-->
	    <input type="hidden" id="cookieroot" value="<?php $this->text('cookieroot') ?>" />
	    <input type="hidden" id="TV_ROOT_ID" value="<?php echo TV_ROOT_ID ?>" />
	    <input type="hidden" id="serverqrybase" value="<?php $this->text('script') ?>" />
	    <input type="hidden" id="pagedbtitle" value="<?php $this->text('pagedbtitle') ?>" />
	    <input type="hidden" id="tvstate" value="<?php echo $this->text('tvstate') ?>" />
	    <input type="hidden" id="isloggedin" value="<?php $this->text('isloggedin') ?>" />
	    <input type="hidden" id="xmlurl" value="<?php $this->text('xmlurl') ?>" />
	    <input type="hidden" id="tv_tt_leafnode" value="<?php $this->msg('tv_tt_leafnode') ?>" />
	    <input type="hidden" id="tv_tt_collapsenode" value="<?php $this->msg('tv_tt_collapsenode') ?>" />
	    <input type="hidden" id="tv_tt_expandnode" value="<?php $this->msg('tv_tt_expandnode') ?>" />
	    <input type="hidden" id="tv_txtleafimg" value="<?php $this->msg('tv_txtleafimg') ?>" />
	    <input type="hidden" id="tv_txtcollapseimg" value="<?php $this->msg('tv_txtcollapseimg') ?>" />
	    <input type="hidden" id="tv_txtexpandimg" value="<?php $this->msg('tv_txtexpandimg') ?>" />
	    <input type="hidden" id="imgdir" value="<?php $this->text('stylepath') ?>/Treeview" />
	    </form>
	    <!-- END data communicated to the client-side treeview code (there
	         may be other generated items in the treeview lists - if any -
	         below) -->
	    <div id="contextHeading"><span
	      class="contextTitle"><?php $this->html('title') ?></span>
	      <span class="subscript"><?php $this->html('alias') ?></span>
	    </div>
	    <div id="navbar"><?php if($this->data['navbar']) $this->html('navbar') ?></div>
	    <div id="aliases"><?php $this->html('aliases') ?></div>
	    <div id="related"><?php $this->html('related') ?></div>
	    <h3 id="siteSub"><?php $this->msg('tagline') ?></h3>
	    <div id="contentSub"<?php $this->html('userlangattributes') ?>><?php $this->html('subtitle') ?></div>
	  </div>
	  <div id="bodyContent">
	    <?php if($this->data['undelete']) { ?><div id="contentSub2"><?php     $this->html('undelete') ?></div><?php } ?>
	    <?php if($this->data['newtalk'] ) { ?><div class="usermessage"><?php $this->html('newtalk')  ?></div><?php } ?>
	    <?php if($this->data['showjumplinks']) { ?>
		<div id="jump-to-nav" class="mw-jump"><?php $this->msg('jumpto') ?> <a href="#column-one"><?php $this->msg('jumptonavigation') ?></a>, <a href="#searchInput"><?php $this->msg('jumptosearch') ?></a></div>
	    <?php } ?>
	    <!-- start content -->
	    <?php $this->html('bodytext') ?>
	    <?php if ($this->data['catlinks']) { $this->html('catlinks'); } ?>
		<?php if($this->data['dataAfterContent']) { $this->html ('dataAfterContent'); } ?>
	    <!-- end content -->
	    <div class="visualClear"></div>
	  </div>
	</div>
	</div>
	</div>
      </div>
      <div id="column-one"<?php $this->html('userlangattributes')  ?>>
	<div id="p-cactions" class="portlet">
	  <h5><?php $this->msg('views') ?></h5>
	  <ul>
	    <?php foreach($this->data['content_actions'] as $key => $action) {
	       ?><li id="ca-<?php echo htmlspecialchars($key) ?>"
	       <?php if($action['class']) { ?>class="<?php echo htmlspecialchars($action['class']) ?>"<?php } ?>
	       ><a href="<?php echo htmlspecialchars($action['href']) ?>"><?php
	       echo htmlspecialchars($action['text']) ?></a></li><?php
	     } ?>
	  </ul>
	</div>
	<div class="portlet" id="p-personal">
		<h5><?php $this->msg('personaltools') ?></h5>
		<div class="pBody">
			<ul<?php $this->html('userlangattributes') ?>>
<?php		foreach($this->getPersonalTools() as $key => $item) { ?>
				<?php echo $this->makeListItem($key, $item); ?>

<?php		} ?>
			</ul>
		</div>
	</div>
	<div class="portlet" id="p-logo">
	  <h5><?php $hdr = 'Site_logo'; $out = wfMessage($hdr)->escaped(); if (wfMessage($hdr)->inContentLanguage()->isBlank()) echo $hdr; else echo $out; ?></h5>
	  <div class="pBody">
	    <a href="<?php echo htmlspecialchars($this->data['nav_urls']['mainpage']['href'])?>"
	    title="<?php $this->msg('mainpage') ?>"><img alt="site logo" src="<?php $this->text('logopath') ?>" /></a>
	  </div>
	</div>
	<script type="<?php $this->text('jsmimetype') ?>"> if (window.isMSIE55) fixalpha(); </script>
<?php $this->searchBox(); ?>
	<div class="portlet" id="p-treeview">
	  <h5><?php $hdr = 'Content_hierarchy'; $out = wfMessage($hdr)->escaped(); if (wfMessage($hdr)->inContentLanguage()->isBlank()) echo $hdr; else echo $out; ?></h5>
	  <div class="pBody">
	  <form action="#"><!-- dummy to prevent (lynx's) validation errors-->
          <input type="hidden" id="expandednodes" value="<?php $this->text('expandednodes') ?>" />
	    <!--div id="tvbar">
		<a id="tvhelplink" title="< ?php $this->msg('tv_tt_helplink')?>"
		   href="< ?php echo $this->data['tvhelpurl']
		   ?>">&nbsp;?&nbsp;</a>
		<input type="hidden" id="baseurl.tvhelplink" value="< ?php $this->text('tvhelpbaseurl') ?>" />
		<input type="hidden" id="dbttl.tvhelplink" value="< ?php $this->text('tvhelppage') ?>" />
		<div id="tvsync">&nbsp;
		</div>
	    </div-->
	    <div><!-- pseudo-li tag-->
	    <?php $this->html('hempty') ?>
	    <ul id="<?php echo TV_ROOT_ID ?>">
	    <?php $this->html('hlinks') ?>
	    </ul>
	    </div>
	  </form>
	  </div>
	</div>
<?php $this->toolBox(); ?>
<?php $this->languageBox(); ?>
      </div><!-- end of the left (by default at least) column -->
      <!-- Ideally this div would be enclosed within the left column div above, but that causes problems with placement in IE8 -->
      <!-- Commented out because several people have (rightly) pointed out that the LED is too small and hidden, and conceals login and account creation options from the user. -->
      <!--div id="tidyicons">
	<h5><?php $hdr = 'Tidy_icons'; $out = wfMessage($hdr)->escaped(); if (wfMessage($hdr)->inContentLanguage()->isBlank()) echo $hdr; else echo $out; ?></h5>
	<a id="i-led" href="<?php $this->text('ledurl') ?>" title="<?php $this->text('ledmsg') ?>"><img onmouseover="tv_dropdown('p-personal', true)" src="<?php  $this->text('stylepath') ?>/Treeview/<?php $this->text('ledimgname') ?>" alt="<?php $this->text('ledmsg') ?>" /></a>
      </div-->
      <div class="visualClear"></div>
      <div class="printClear">&nbsp;</div><!-- seems to fix a Firefox issue -->
<?php
	$validFooterIcons = $this->get('footericons');
	$validFooterLinks = $this->getFooterLinks( "flat" ); // Additional footer links

	if ( count( $validFooterIcons ) + count( $validFooterLinks ) > 0 ) { ?>
<div id="footer"<?php $this->html('userlangattributes') ?>>
<?php
		$footerEnd = '</div>';
	} else {
		$footerEnd = '';
	}
	foreach ( $validFooterIcons as $blockName => $footerIcons ) { ?>
	<div id="f-<?php echo htmlspecialchars($blockName); ?>ico">
<?php foreach ( $footerIcons as $icon ) { ?>
		<?php echo $this->getSkin()->makeFooterIcon( $icon ); ?>

<?php }
?>
	</div>
<?php }

		if ( count( $validFooterLinks ) > 0 ) {
?>	<ul id="f-list">
<?php
			foreach( $validFooterLinks as $aLink ) {
				if (!($wgTreeviewDisableViewcount && $aLink === 'viewcount')) {
?>
		<li id="<?php echo $aLink ?>"><?php $this->html($aLink) ?></li>
<?php
				}
			}
?>
	</ul>
<?php	}
echo $footerEnd;
?>
    </div>
    <!-- must occur last so that defer can be specified and it can be assumed
         that the rest of the page has loaded when the script runs -->
    <script defer="defer" type="<?php $this->text('jsmimetype') ?>" src="<?php $this->text('stylepath') ?>/Treeview/treeview.js"></script>
<?php if ( $this->data['debug'] ): ?>
<!-- Debug output:
<?php $this->text( 'debug' ); ?>

-->
<?php endif; ?>
  </body>
</html>
<?php
		if (function_exists('wfRestoreWarnings')) wfRestoreWarnings();
	}


	function searchBox() {
		global $wgUseTwoButtonsSearchForm;
		// var_export(RequestContext::getMain()->getUser());
		// exit;

?>
	<div id="p-search" class="portlet">
		<h5><label for="searchInput"><?php $this->msg('search') ?></label></h5>
		<div id="searchBody" class="pBody">
			<form action="<?php $this->text('wgScript') ?>" id="searchform">
				<input type='hidden' name="title" value="<?php $this->text('searchtitle') ?>"/>
				<?php echo $this->makeSearchInput(array( "id" => "searchInput" )); ?>

				<?php echo $this->makeSearchButton("go", array( "id" => "searchGoButton", "class" => "searchButton" ));
				if ($wgUseTwoButtonsSearchForm): ?>&#160;
				<?php echo $this->makeSearchButton("fulltext", array( "id" => "mw-searchButton", "class" => "searchButton" ));
				else: ?>

				<div><a href="<?php echo SpecialPage::newSearchPage(RequestContext::getMain()->getUser())->getLocalURL(); ?>" rel="search"><?php $this->msg('powersearch-legend') ?></a></div><?php
				endif; ?>

			</form>
		</div>
	</div>
<?php
	}

	function toolbox() {
?>
	<div class="portlet" id="p-tb">
		<h5><?php $this->msg('toolbox') ?></h5>
		<div class="pBody">
			<ul>
<?php
		foreach ($this->data['sidebar']['TOOLBOX'] as $key => $tbitem) { ?>
				<?php echo $this->makeListItem($key, $tbitem); ?>

<?php
		}
//		Hooks::Run( 'MonoBookTemplateToolboxEnd', array( &$this ) );
//		Hooks::Run( 'SkinTemplateToolboxEnd', array( &$this, true ) );
?>
			</ul>
		</div>
	</div>
<?php
	}

	/*************************************************************************************************/
	function languageBox() {
		if( $this->data['language_urls'] ) {
?>
	<div id="p-lang" class="portlet">
		<h5<?php $this->html('userlangattributes') ?>><?php $this->msg('otherlanguages') ?></h5>
		<div class="pBody">
			<ul>
<?php		foreach($this->data['language_urls'] as $key => $langlink) { ?>
				<?php echo $this->makeListItem($key, $langlink); ?>

<?php		} ?>
			</ul>
		</div>
	</div>
<?php
		}
	}
}
?>
